package edu.lawrence.survey;

import java.util.List;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/questions")
@CrossOrigin(origins="*")
public class QuestionController {
    private QuestionDAO dao;
    
    public QuestionController(QuestionDAO dao) {
        this.dao = dao;
    }
    
    @GetMapping(params={"survey"})
    public List<Question> getQuestionsForSurvey(@RequestParam int survey) {
        return dao.findBySurvey(survey);
    }
    
    @PostMapping()
    public String addQuestion(@RequestBody Question q) {
        dao.save(q);
        return "\"saved\"";
    }
}
