package edu.lawrence.survey;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class QuestionDAO {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<Question> findBySurvey(int id) {
	String sql = "SELECT * FROM question WHERE survey=?";
        RowMapper<Question> rowMapper = new QuestionRowMapper();
        return jdbcTemplate.query(sql, rowMapper, id);
    }
    
    public void save(Question p) {
        String insertSQL = "INSERT INTO question (survey,question,responses) values (?, ?, ?)";
        jdbcTemplate.update(insertSQL,p.getSurvey(),p.getQuestion(),p.getResponses());
    }
}
