package edu.lawrence.survey;

import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/responses")
@CrossOrigin(origins="*")
public class ResponseController {
    private ResponseDAO rDAO;
    private QuestionDAO qDAO;
    
    public ResponseController(ResponseDAO rd,QuestionDAO qd) {
        this.rDAO = rd;
        this.qDAO = qd;
    }
    
    @GetMapping(params={"survey"})
    public List<ResponseSummary> getSummaries(@RequestParam int survey) {
        List<Question> questions = qDAO.findBySurvey(survey);
        List<ResponseSummary> summaries = new ArrayList<ResponseSummary>();
        for(Question q : questions) {
            ResponseSummary summary = new ResponseSummary();
            summary.setPrompt(q.getQuestion());
            List<String> replies = new ArrayList<String>();
            if(q.getResponses().isEmpty()) {
                List<Response> responses = rDAO.findBySurveyAndQuestion(survey, q.getIdquestion());
                for(Response r : responses) {
                    replies.add(r.getResponse());
                }
                summary.setResponses(replies);
                summary.setTallys(new ArrayList<VoteTally>());
            } else {
                summary.setResponses(replies);
                summary.setTallys(rDAO.findTallies(survey,q.getIdquestion()));
            }
            summaries.add(summary);
        }
        return summaries;
    }
    
    @PostMapping()
    public void addResponse(@RequestBody Response r) {
        rDAO.save(r);
    }
}
