package edu.lawrence.survey;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ResponseDAO {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public List<Response> findBySurveyAndQuestion(int survey,int question) {
	String sql = "SELECT * FROM response WHERE survey=? AND question=?";
        RowMapper<Response> rowMapper = new ResponseRowMapper();
        return jdbcTemplate.query(sql, rowMapper, survey, question);
    }
    
    public List<VoteTally> findTallies(int survey,int question) {
	String sql = "SELECT response, count(response) as votes FROM response WHERE survey=? AND question=? GROUP BY response";
        RowMapper<VoteTally> rowMapper = new VoteTallyRowMapper();
        return jdbcTemplate.query(sql, rowMapper,survey, question);
    }
    
    public void save(Response r) {
        String insertSQL = "INSERT INTO response (survey,question,response) values (?, ?, ?)";
        jdbcTemplate.update(insertSQL,r.getSurvey(),r.getQuestion(),r.getResponse());
    }
}
