package edu.lawrence.survey;

import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/surveys")
@CrossOrigin(origins="*")
public class SurveyController {
    private SurveyDAO dao;
    
    public SurveyController(SurveyDAO dao) {
        this.dao = dao;
    }
    
    @GetMapping(params={"id"})
    public Survey findSurvey(@RequestParam int id) {
        return dao.findById(id);
    }
    
    @PostMapping()
    public long addSurvey(@RequestBody Survey s) {
        return dao.save(s);
    }
}
