package edu.lawrence.survey;

import java.sql.PreparedStatement;
import java.sql.Statement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.stereotype.Repository;

@Repository
public class SurveyDAO {
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public Survey findById(int id) {
	String sql = "SELECT * FROM survey WHERE idsurvey=?";
        RowMapper<Survey> rowMapper = new SurveyRowMapper();
        return jdbcTemplate.queryForObject(sql, rowMapper, id);
    }
    
    public long save(Survey s) {
        String insertSQL = "INSERT INTO survey (title,prompt) values (?, ?)";
        KeyHolder keyHolder = new GeneratedKeyHolder();

        jdbcTemplate.update(connection -> {
              PreparedStatement ps = connection
              .prepareStatement(insertSQL, Statement.RETURN_GENERATED_KEYS);
              ps.setString(1, s.getTitle());
              ps.setString(2,s.getPrompt());
              return ps;
            }, keyHolder);

        return keyHolder.getKey().longValue();
    }
}
